%
%   Book: MATLAB-Based Electromagnetics (Pearson Prentice Hall)
%   Author: Branislav M. Notaros
%   Instructor Resources
%   (c) 2011
%
%   This MATLAB code or any part of it may be used only for educational purposes 
%   associated with the book
%
%
%


%   Vector numerical integration and field visualization using quiver


clear all;
close all;

EPS0 = 8.8542 * 10^(-12);
a = input('Dimension of a line at the origin in cm: ');
a = a*10^(-2);
Q = input('Total charge in nC: ');
Q = Q *10^(-9);
rho = Q/a ;
dl = 0.001*a;
xline = -a/2 : dl : a/2;
yline = zeros (1,length (xline));

v = -0.825*a: 0.15*a : 0.975*a;
u = -0.525*a: 0.15*a : 0.675*a;
[x,y] = meshgrid(v,u);
[M,N] = size(x);

for i = 1 : M
    for j = 1 : N
        for t = 1 : length(xline)
            r(i,j,t,:) = [x(i,j) - xline(t) y(i,j) - yline(t)];
            rabs(i,j,t) = vectorMag(r(i,j,t,:));
            runit(i,j,t,:) = r(i,j,t,:)/rabs(i,j,t);
            E(i,j,t,:) = rho*dl*runit(i,j,t,:)/(4*pi*EPS0*rabs(i,j,t)^2);
        end;
        Etotx(i,j) = sum(E(i,j,:,1));
        Etoty(i,j) = sum(E(i,j,:,2));
    end;
end;
figure(1);
line([-a/2 a/2],[0 0]);
hold on;
quiver(v,u,Etotx,Etoty);
hold off;
title('Field distribution');
xlabel('x[m]');
ylabel('y[m]');